/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.views;

import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.JSModelFormatter;
import com.aptana.js.core.model.BaseElement;
import com.aptana.js.core.model.ClassElement;
import com.aptana.js.core.model.ClassGroupElement;
import com.aptana.js.core.model.EventElement;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.JSElement;
import com.aptana.js.core.model.PropertyElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class JSIndexViewLabelProvider
implements ILabelProvider,
ILabelDecorator {
    private static final Image CLASS_ICON = JSPlugin.getImage("icons/class.png");
    private static final Image CONSTRUCTOR_ICON = JSPlugin.getImage("icons/constructor.png");
    private static final Image FUNCTION_ICON = JSPlugin.getImage("icons/js_function.png");
    private static final Image PROPERTY_ICON = JSPlugin.getImage("icons/js_property.png");
    private static final Image FOLDER_ICON = JSPlugin.getImage("icons/folder.png");
    private static final Image SCRIPT_ICON = JSPlugin.getImage("icons/js.png");
    private static final Image EVENT_ICON = JSPlugin.getImage("icons/event.gif");
    private static final ImageDescriptor STATIC_OVERLAY = JSPlugin.getImageDescriptor("icons/overlays/static.png");
    private static JSModelFormatter modelFormatter = JSModelFormatter.LABEL;

    public void addListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        PropertyElement property;
        Image result = null;
        if (image != null && element instanceof PropertyElement && (property = (PropertyElement)element).isClassProperty()) {
            DecorationOverlayIcon decorator = new DecorationOverlayIcon(image, STATIC_OVERLAY, 1);
            result = decorator.createImage();
        }
        return result;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void dispose() {
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof JSElement) {
            result = SCRIPT_ICON;
        } else if (element instanceof ClassGroupElement) {
            result = FOLDER_ICON;
        } else if (element instanceof ClassElement) {
            result = CLASS_ICON;
        } else if (element instanceof FunctionElement) {
            FunctionElement function = (FunctionElement)element;
            result = function.getName().equals(function.getOwningType()) ? CONSTRUCTOR_ICON : FUNCTION_ICON;
        } else if (element instanceof PropertyElement) {
            result = modelFormatter.getImage((PropertyElement)element);
        } else if (element instanceof EventElement) {
            result = EVENT_ICON;
        } else if (element instanceof BaseElement) {
            result = PROPERTY_ICON;
        }
        Image decorated = this.decorateImage(result, element);
        if (decorated != null) {
            result = decorated;
        }
        return result;
    }

    public String getText(Object element) {
        String result = null;
        if (element instanceof FunctionElement) {
            FunctionElement function = (FunctionElement)element;
            result = modelFormatter.getDescription((BaseElement)function, null);
        } else if (element instanceof BaseElement) {
            result = ((BaseElement)element).getName();
        }
        return result;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

